$(document).ready(function(){
	
	var camera = $('#camera');
	var photos = $('#photos'),
		 screen = $('#screen');

	var template = '<a href="uploads/original/{src}" rel="cam" '
		+'style="background-image:url(uploads/thumbs/{src})"></a>';

	/*----------------------------------
		Setting up the web camera
	----------------------------------*/
	webcam.set_swf_url("assets/photo/webcam/webcam.swf");	// 載入flash攝影組件的路徑
	// webcam.set_swf_url("{{url('assets/photo/webcam/webcam.swf')}}");	// 載入flash攝影組件的路徑
	webcam.set_api_url('upload.php');	// The upload script 處理上傳照片的php
	webcam.set_quality(80);				// JPEG Photo Quality 設定JPEG品質
	// webcam.set_shutter_sound(true, 'photo/webcam/shutter.mp3');	//設定拍照聲音

	// Generating the embed code and adding it to the page:	
	screen.html(
		webcam.get_html(screen.width(), screen.height())	//在#screen中載入攝影元件
	);


	/*----------------------------------
		Binding event listeners
	----------------------------------*/


	var shootEnabled = false;
	
	//拍照
	$('#shootButton').click(function(){
		
		if(!shootEnabled){
			return false;
		}
		
		webcam.freeze();	//凍結webcam，攝影鏡頭停止工作
		togglePane();
		return false;
	});
	
	//取消拍照
	$('#cancelButton').click(function(){
		webcam.reset();	//重置webcam，攝影鏡頭重新開始工作
		togglePane();
		return false;
	});
	
	//上傳照片
	$('#uploadButton').click(function(){
		webcam.upload();	//上傳
		webcam.reset();	//重置webcam，攝影鏡頭重新開始工作
		togglePane();
		return false;
	});

	// camera.find('.settings').click(function(){
	// 	if(!shootEnabled){
	// 		return false;
	// 	}
		
	// 	webcam.configure('camera');
	// });

	// Showing and hiding the camera panel:
	
	// var shown = false;
	// $('.camTop').click(function(){
		
	// 	// $('.tooltip').fadeOut('fast');
		
	// 	if(shown){
	// 		camera.animate({
	// 			bottom:-466
	// 		});
	// 	}
	// 	else {
	// 		camera.animate({
	// 			bottom:-5
	// 		},{easing:'easeOutExpo',duration:'slow'});
	// 	}
		
	// 	shown = !shown;
	// });

	// $('.tooltip').mouseenter(function(){
	// 	$(this).fadeOut('fast');
	// });


	/*---------------------- 
		Callbacks
	----------------------*/
	
	webcam.set_hook('onLoad',function(){
		// When the flash loads, enable
		// the Shoot and settings buttons:
		shootEnabled = true;
	});
	
	//webcame透過set_hook方法接收後台php(upload.php)回傳的訊息
	webcam.set_hook('onComplete', function(msg){	//onComplete表示上傳完成
		
		// This response is returned by upload.php
		// and it holds the name of the image in a
		// JSON object format:
		
		msg = $.parseJSON(msg);	//解析JSON
		
		if(msg.error){
			alert(msg.message);
		}
		else {
			// Adding it to the page;
			photos.prepend(templateReplace(template,{src:msg.filename}));	//將取得的資訊插入到index.html裡的#photos裡
			initFancyBox();	//使用fancybox插件
		}
	});
	
	webcam.set_hook('onError',function(e){	//onError表示上傳失敗
		screen.html(e);
	});
	
	
	/*-------------------------------------
		Populating the page with images
	-------------------------------------*/
	
	var start = '';
	
	function loadPics(){
	
		// This is true when loadPics is called
		// as an event handler for the LoadMore button:
		
		if(this != window){
			if($(this).html() == 'Loading..'){
				// Preventing more than one click
				return false;
			}
			$(this).html('Loading..');
		}
		
		// Issuing an AJAX request. The start parameter
		// is either empty or holds the name of the first
		// image to be displayed. Useful for pagination:
		//動態載入最新的照片顯示在頁面上
		//函數loadPic()向browse.php發出get請求，並將回傳的json解析，將照片訊息動態插入至元素#photos下
		//使用fancybox插件
		
		$.getJSON('browse.php',{'start':start},function(r){
			
			photos.find('a').show();
			var loadMore = $('#loadMore').detach();
			
			if(!loadMore.length){
				loadMore = $('<span>',{
					id			: 'loadMore',
					html		: 'Load More',
					click		: loadPics
				});
			}
			
			$.each(r.files,function(i,filename){
				photos.append(templateReplace(template,{src:filename}));
			});

			// If there is a next page with images:			
			if(r.nextStart){
				
				// r.nextStart holds the name of the image
				// that comes after the last one shown currently.
				
				start = r.nextStart;
				photos.find('a:last').hide();
				photos.append(loadMore.html('Load More'));
			}
			
			// We have to re-initialize fancybox every
			// time we add new photos to the page:
			
			initFancyBox();	//使用fancybox
		});
		
		return false;
	}

	// Automatically calling loadPics to
	// populate the page onload:
	
	loadPics();
	

	/*----------------------
		Helper functions
	------------------------*/

	
	// This function initializes the
	// fancybox lightbox script.
	//使用fancybox
	function initFancyBox(filename){
		photos.find('a:visible').fancybox({
			'transitionIn'	: 'elastic',
			'transitionOut'	: 'elastic',
			'overlayColor'	: '#111'
		});
	}


	// This function toggles the two
	// .buttonPane divs into visibility:
	//顯示or隱藏拍照按鈕
	//顯示or隱藏取消和上傳按鈕
	function togglePane(){
		var visible = $('#camera .buttonPane:visible:first');
		var hidden = $('#camera .buttonPane:hidden:first');
		
		visible.fadeOut('fast',function(){
			hidden.show();
		});
	}
	
	
	// Helper function for replacing "{KEYWORD}" with
	// the respectful values of an object:
	function templateReplace(template,data){
		return template.replace(/{([^}]+)}/g,function(match,group){
			return data[group.toLowerCase()];
		});
	}
});
