﻿// (c) ammap.com | SVG (in JSON format) map of Central African Republic - Low
// areas: {id:"CF-AC"},{id:"CF-BB"},{id:"CF-BGF"},{id:"CF-BK"},{id:"CF-HK"},{id:"CF-HM"},{id:"CF-HS"},{id:"CF-KB"},{id:"CF-KG"},{id:"CF-LB"},{id:"CF-MB"},{id:"CF-MP"},{id:"CF-NM"},{id:"CF-OP"},{id:"CF-SE"},{id:"CF-UK"},{id:"CF-VK"}
AmCharts.maps.centralAfricanRepublicLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"14.421294",
				"topLatitude":"11.007570",
				"rightLongitude":"27.464141",
				"bottomLatitude":"2.219642"
			}
		},
		"g":{
			"path":[
				{
					"id":"CF-AC",
					"title":"Ouham",
					"d":"M443.9,221.36L444.05,225.58L442.45,227.64L443.92,229.27L442.4,232.16L444.1,235.45L442.07,236.51L442.55,239.75L440.65,240.73L441.02,244.64L438.97,245.67L438.62,248.33L439.22,250.17L442.4,251.45L443.07,253.78L443.25,258.15L441.45,259.96L442.6,263.07L440.82,264.9L442.45,266.96L439.47,271.3L439.8,278.4L435.95,280.78L437.82,283.27L435,286L436.5,288.21L435.07,290.56L435.37,293.22L439.12,294.48L415.51,305.58L411.79,308.79L423.34,340.39L417.04,344.02L416.24,348.7L411.04,352.01L411.11,353.56L414.34,354.23L414.26,356.04L411.44,357.64L409.86,363.75L406.16,366.05L405.73,368.43L410.89,373.06L412.61,379.51L415.31,379.74L413.66,383.12L414.29,385.32L419.79,389.5L424.79,391.15L426.02,393.02L424.72,395.75L416.86,400.23L414.89,406.73L414.89,406.73L413.99,410.15L424.92,420.95L424.97,431.78L429.44,435.58L428.62,437L424.29,438.33L409.59,450.87L403.08,453.39L404.38,458.11L401.86,463.76L403.73,468.43L404.21,477.23L404.21,477.23L402.28,476.94L402.58,481.16L400.83,484.96L383.77,492.6L382.92,485.91L380.47,481.21L383.38,478.49L383.05,476.57L378.25,474.7L371.95,475.89L370.84,471.8L368.67,470.6L358.29,472.12L354.91,469.68L349.64,471.27L347.76,469.88L347.46,466.21L346.01,466.4L338.73,461.58L333.96,462.93L329.53,467.98L311.02,478.54L259.73,479.24L254.67,470.45L255.15,465.75L255.15,465.75L253.97,461.53L251.05,457.74L250.62,449.52L248.5,443.2L252.97,441L251.47,433.3L253.02,426.33L258.52,425.48L258.27,424.06L259.68,423.03L258.9,420.21L260.83,419.98L263,417.18L265.35,417.4L266.2,412.43L260.7,409.05L258.8,410.2L253.67,409.28L252.45,411.9L249.32,412.25L243.69,408.7L241.69,404.08L238.44,402.88L238.12,399.02L240.11,396.95L237.94,398.75L235.64,397.15L235.04,389.52L232.39,383.67L232.31,373.68L231.06,369.33L228.84,367.85L227.96,363.87L230.29,362.5L229.84,359.47L232.62,358.84L236.37,351.88L234.84,345.19L237.17,339.31L238.37,327.79L242.04,324.05L240.12,320.02L241.1,314.99L241.1,314.99L248.82,312.69L247.7,311.21L248.18,307.43L253.23,305.67L260.73,305.75L261.53,303.94L265.26,303.46L265.32,300.6L267.51,301.01L268.99,303.21L271.55,302.89L272.78,300.93L272.02,299.64L276.78,297.49L278.04,294.17L280.75,295.65L280.93,292.3L284.89,288.36L299.21,282.37L303.47,284.66L306.36,279.91L308.37,281.1L310.81,278.88L312.61,279.41L315.52,277.71L317.57,274.36L340.08,276.54L350.02,271.96L402.36,268.27L404.49,264.58L403.69,260.05L407.16,254.21L419.56,249.25L422.51,246.69L424.31,243.54L423.71,241.42L426.03,241.98L430.32,237.52L430.12,234.47L434.51,230.85L436.93,227.62L436.23,226.44L439.79,224.68L441.2,221.27L441.2,221.27z"
				},
				{
					"id":"CF-BB",
					"title":"Bamingui-Bangoran",
					"d":"M599.64,142.26L603.36,147.75L607.24,148.26L611.47,142.99L617.82,140.73L621.32,134.66L626.67,131.98L636.1,131.15L640.55,129.49L643.83,126.49L645.33,122.81L649.23,119.26L655.81,115.98L657.89,112.27L662.01,112.65L664.24,127.85L666.04,129.06L673.04,128.66L674.99,132.34L680.85,137.4L682.12,141.58L687.22,145.66L688.6,155.06L691.57,158.61L693.77,165.88L698.38,168.12L701.13,172.35L707.18,175.97L709.03,181.73L715.33,185.08L714.66,188.15L718.31,203.76L726.26,209.34L741.47,212.51L742.69,213.97L742.49,219.32L742.49,219.32L739.12,221.71L722.46,220.2L714.06,216.46L706.56,218.84L703.33,225.43L707.43,236.13L703.53,246.63L706.83,251.57L706.35,253.08L698.2,255.11L694.73,254.53L692.5,249.01L685.17,242.33L677.44,246.78L672.97,247.38L671.07,251.75L665.96,249.69L660.46,249.99L659.96,253.15L651.33,259.25L658.01,272.75L628.22,272.83L628.9,281.61L626.4,286.58L628.55,290.96L629.02,299.59L629.02,299.59L627.07,301.04L625.72,306.76L622.22,309.37L622.2,312.25L624.47,316.74L618.99,321.47L609.19,336.3L598.86,342.69L592.31,340.61L588.71,341.19L584.96,351.18L578.33,356.91L573.38,357.06L567.77,361.32L565.72,361.27L563.92,359.34L562.72,360.67L560.22,360.24L558.32,361.39L555.34,359.89L548.04,360.04L546.22,357.59L542.16,356.49L541.49,354.68L541.49,354.68L538.86,354.38L538.49,352.01L536.46,352.38L534.06,351L527.66,344.34L521.58,342.56L518.05,338.63L517.68,332.52L515.68,329.61L512.7,329.99L509.13,323.7L505.75,323.53L505.77,318.26L503.07,317.11L503,314.28L501.62,314.43L500.35,312.63L497.57,314.13L496.17,312.45L489.49,311.47L489.22,308.31L490.72,304.4L487.94,303.2L489.99,300.22L487.32,300.94L482.81,296.71L479.21,297.81L476.46,294.95L475.24,297.23L471.89,293.75L470.29,295.96L466.86,292.02L465.96,289.89L468.68,287.7L466.08,284.14L468.96,280.88L467.21,278.3L469.43,275.64L468.16,271.47L471.31,269.14L468.76,267.26L470.09,263.19L467.51,257.82L459.13,249.86L459.58,248.38L458.26,247.81L459.31,245.7L457.05,241.88L451.65,237.89L448.4,231.31L446.68,230.45L445.18,222.24L443.9,221.36L443.9,221.36L443.9,221.36L443.9,221.36L441.2,221.27L441.2,221.27L443.1,215.19L448.11,211.75L446.63,209.64L440.93,207.04L438.47,203.57L433.6,201.55L432.36,199.32L429.04,199.84L428.24,195.89L426.49,196.81L424.79,195.71L425.31,193.62L430.21,189.07L433.6,188.92L436.05,184.61L439.27,182.81L442.45,182.75L445.43,180.51L449.34,181.96L456.83,179.51L465.01,181.66L476.71,179.54L480.31,181.06L482.8,179.27L484.26,180.89L489.18,178.74L491.37,180.61L497.68,180.48L502.13,178.34L511.22,176.54L512.98,178.38L515.01,176.52L520.65,176.86L521.75,174.48L525.43,174.03L527.02,171.82L531.95,169.45L534.54,170.29L536.34,168.18L538.97,169.85L547.13,168.61L551.85,171.3L559.01,170.75L567.75,167.36L572.05,157.71L571.85,154.54L574.38,154.49L574.8,151.82L578.29,152.44L579.51,151.3L581.62,153.69L584.64,153.57L586.88,146.54L595.71,146.01L596.37,143.57z"
				},
				{
					"id":"CF-BGF",
					"title":"Bangui",
					"d":"M407.24,601.04L401.77,600.54L398.32,602.53L398.32,602.53L396.3,598.95L398.53,594.92L404.39,594.31z"
				},
				{
					"id":"CF-BK",
					"title":"Basse-Kotto",
					"d":"M567.95,585.02L578.93,579.67L591.23,565.21L600.06,560.75L605.26,561.65L608.77,559.08L607.67,548.33L611.72,540.08L608.29,532L613.12,523.69L613.99,514.63L613.04,508.69L616.27,504.8L615.37,499.11L611.69,496.37L612.64,495.12L619.62,493.32L619.12,489L622.47,484.46L619.94,480.51L620.37,478.57L624.55,479.22L628.35,484.36L632,483.93L633.42,482.54L638.43,484.91L643.85,482.41L647.66,478.57L650.51,480.79L653.08,477.24L654.86,480.34L657.84,481.16L660.66,486.11L660.61,490.57L663.41,497.51L666.29,497.99L667.84,500.91L674.54,499.59L676.92,493.57L676.92,493.57L684.92,494.24L698.3,500.01L698.3,500.01L697.6,505.13L698.9,510.04L697.48,514.46L697.13,525.61L694.55,530.32L688.65,534.74L692.1,543.17L687.1,550.33L686.62,559.9L684.47,563.84L683.8,570.1L691,571.17L692.9,573.79L696.2,573.66L697.18,575.71L699.55,575.18L699.43,578.47L703.25,581.91L701.88,584.53L702.93,585.33L707.41,586.27L714.08,583.91L718.23,584.25L720.39,585.77L719.28,590.88L713.03,600.48L713.98,606.48L710.73,609.32L710.48,612.74L710.48,612.74L706.66,611.05L703.63,612.55L694.61,611.09L689.69,608.4L686.73,608.39L683.38,605.36L678.18,606.1L675.82,604.89L668.1,610.43L659.44,608.5L655.77,609.24L647.35,606.25L642.65,602.31L639.8,603.08L638.58,606.12L636.27,606.87L627.95,602.47L624.03,597.42L605.13,592.63L598.74,595.49L592.77,594.85L582.37,596.59L570.23,589.07z"
				},
				{
					"id":"CF-HK",
					"title":"Haute-Kotto",
					"d":"M842.61,185.8L845.15,185.67L848.6,181.62L850.1,182.61L849.63,191.17L846.52,196.24L843.1,199.13L844.15,207.08L846.35,207.92L849.31,205.85L854.01,205.49L863.85,208.06L870.97,206.18L875.96,208.03L882,206.8L886.85,208.8L899.22,210.21L902.16,208.81L905.89,210.59L910.1,208.46L910.75,210.99L908.25,215.69L911.64,219.59L902.77,229.28L901.03,237.78L905.68,245.34L912.29,248.18L912.29,248.18L913.59,251.4L919.92,256.67L924.69,258.15L925.19,262.59L930.95,267.53L929.57,276.37L927.79,278.75L929.42,287.48L931.32,291.19L930.75,295.65L932.55,298.74L932.02,305.91L936.15,315.11L938.25,316.01L937.35,317.29L941.02,319.07L933.2,334.52L934.27,338.21L933.37,340.56L936.17,340.66L935.6,343.02L937.97,344.94L935.92,354.66L937.35,360.17L936.12,362.57L933.85,361.99L931.67,365.25L918.84,366.27L918.36,368.2L916.06,368.95L918.82,373.81L916.69,374.51L916.89,377.44L912.79,379.41L915.29,383.22L911.51,383.09L910.83,385.31L910.83,385.31L837.23,426.2L832.71,434.2L825.78,434.2L825.35,436.55L823.53,437.78L823.93,443.52L821.8,445.65L785.96,436.2L782.79,429.65L780.44,428.4L774.78,429.65L768.58,428.35L756.32,430.9L749.35,445.67L741.49,449.82L738.47,448.9L733.29,449.77L731.49,447.22L728.94,447.32L727.94,449.1L721.84,451.07L716.86,455.39L718.33,458.09L713.96,463.43L713.76,474.82L711.56,477.47L714.68,485.63L710.11,485.71L709.26,487.28L711.38,488.18L710.43,489.65L704.2,493.74L698.3,500.01L698.3,500.01L684.92,494.24L676.92,493.57L676.92,493.57L676.84,489.25L685.92,482.11L694.52,487.58L698.38,482.56L701.9,469.15L702.35,461.16L699.13,457.44L697.18,449.69L690.95,448.55L691.17,444.9L688.35,436.85L683.6,433.23L690.32,422.23L686.92,413.33L688.77,402.55L686.77,400.43L680.37,399.68L674.82,391.22L674.29,385.89L671.92,383.84L671.97,382.27L675.19,380.01L674.67,376.41L676.12,373.83L674.22,369.78L674.44,364.77L671.67,363.77L669.09,347.15L669.06,336.25L667.09,334.93L662.04,335.78L655.11,334.8L654.08,332.17L655.41,319.97L652.58,314.25L646.21,309.32L636.5,307.14L629.02,299.59L629.02,299.59L628.55,290.96L626.4,286.58L628.9,281.61L628.22,272.83L658.01,272.75L651.33,259.25L659.96,253.15L660.46,249.99L665.96,249.69L671.07,251.75L672.97,247.38L677.44,246.78L685.17,242.33L692.5,249.01L694.73,254.53L698.2,255.11L706.35,253.08L706.83,251.57L703.53,246.63L707.43,236.13L703.33,225.43L706.56,218.84L714.06,216.46L722.46,220.2L739.12,221.71L742.49,219.32L742.49,219.32L746.42,218.57L750.75,220.15L754.27,219.82L759.6,214.45L767.73,209.52L780.66,209.42L791.76,204.87L798.09,203.86L802.44,204.64L804.54,201.58L804.54,193.15L805.65,191.09L815.4,183.97L821.58,183.12L826.15,179.87L828.58,166.66L830.85,162.91L834.76,160.67L839.61,161.07L837.73,166.06L839.98,170.7L839.98,170.7L839.14,178.23L837.64,180.82L839.23,184.06z"
				},
				{
					"id":"CF-HM",
					"title":"Haut-Mbomou",
					"d":"M927.88,248.02L930.17,247.93L931.77,251.33L937.23,254.35L945.61,252.37L953.95,253.93L955.9,256.21L962.25,255.57L965.21,256.5L967.37,260.37L968.91,268.15L972.49,270.26L974.84,274.28L982.68,279.36L985.78,283.31L993.6,281.57L996.61,284.81L998.18,284.75L1001.43,290.91L1003.46,290.89L1002.62,300.08L1004.84,303.02L1003.41,303.27L1003.3,305.4L993.18,310.78L995.16,314.68L995.43,318.93L998.89,320.45L1002.21,320.16L1005.31,324.91L1007.69,325L1009.9,331.96L1018.06,335.41L1018.16,337.51L1022.33,338.92L1024.79,338.05L1026.86,340.32L1028.79,340.48L1028.62,342.02L1031.05,341.79L1031.23,343.31L1040.47,345.6L1042.2,347.73L1044.15,346.99L1045.02,348.69L1051.05,349.57L1050.94,353.03L1057.44,354.29L1059.01,355.53L1057.89,357.1L1060.48,357.73L1061.06,359.22L1065.43,359.69L1066.13,362.4L1071.8,362.97L1072.37,367.99L1071.1,369.77L1073.07,369.89L1073.54,371.97L1075.45,371.66L1075.13,376.15L1076.84,378.89L1082.51,379.85L1083.34,382.3L1086.19,384.38L1086.08,385.79L1090.62,386.98L1091.09,389.23L1099.61,391.03L1104.08,394.38L1104.8,395.69L1103.78,398L1101.79,399.51L1101.8,400.96L1099.19,401.28L1096.28,406.95L1096.86,408.23L1094.19,408.6L1093.23,411.43L1094.76,411.17L1094.49,413.36L1095.85,414.38L1093.9,416.88L1094.25,418.16L1102.06,424.95L1110.24,428.1L1109.96,431.72L1111.43,433.75L1114.04,432.68L1115.63,433.7L1113.32,438.84L1108.76,441.91L1108.05,445.33L1108.87,446.05L1114.16,442.65L1117.86,450.05L1121.94,450.35L1126.4,452.6L1128.97,451.34L1132.23,452.51L1135.11,451.85L1140.4,454.17L1143.25,462.68L1146.04,463.62L1149.89,462.61L1153.75,466.72L1157.19,465.78L1158.9,466.68L1162.05,471.9L1166.81,470.96L1168.27,473.24L1171.91,473.96L1170.52,475.59L1174.42,477.55L1177.05,481.11L1176.61,482.7L1178.82,485.11L1178.88,490.01L1180.83,488.96L1182.98,490.17L1181.94,492.03L1182.36,495.27L1178.46,504.56L1179.06,508.68L1180.63,510.44L1179.87,513.54L1185.91,524.23L1193.17,529.2L1194.01,532.22L1198.45,536.45L1199.19,541.45L1197.17,540.92L1197.31,537.2L1194.79,535.01L1178.33,529.22L1171.63,524.97L1167.56,524.33L1160.08,526.1L1151.62,530.85L1149.56,535.71L1147.66,536.29L1145.95,539.86L1142.29,537.58L1140.19,538.49L1136.87,535.21L1136.97,533.76L1129.6,535.04L1128.77,534.25L1127.72,535.95L1125.14,534.94L1124.05,537.2L1122.76,535.69L1119.21,535.64L1119.15,537.21L1117.6,536.03L1116.07,538.72L1116.19,536.8L1114.85,538.93L1111.36,538.73L1108.47,537L1108.75,534.35L1107.12,534.71L1107.14,532.66L1105.61,532.75L1104.71,530.95L1103.39,532.01L1102.62,529.66L1100.41,530.07L1099.05,528.94L1096.88,530.66L1095.87,529.13L1094.73,530.25L1094,528.46L1092.91,528.89L1093.14,527.69L1090.35,527.49L1090.28,525.12L1089.33,526.42L1088.81,524.17L1087.34,525.48L1086.16,521.61L1084.24,523.33L1084.25,521.2L1082.21,522.35L1082.14,519.91L1080.12,519.27L1077.93,522.25L1075.62,521.66L1076.39,524.2L1074.34,523.75L1073.54,525.47L1072.25,523.74L1070.87,524.73L1068.41,524.2L1068.26,522.38L1066.76,523.13L1066.09,521.37L1064.42,522.87L1064.18,525.68L1062.23,524.34L1059.28,524.91L1059.19,528.09L1056.96,523.26L1053.66,523.87L1052.65,526.12L1051.28,523.4L1050.22,523.57L1051.23,520.82L1048.52,521.55L1049.49,520.16L1048.74,518.41L1046.72,519.22L1047.92,520.31L1044.85,521.64L1041.21,516.22L1036.89,515.4L1036.7,513.44L1034.16,515.64L1033.56,514.03L1031.57,513.91L1033.45,511.69L1031.15,511.87L1029.74,509.2L1026.55,508.22L1025.59,509.07L1026.69,511.05L1023.43,512.01L1021.23,510.04L1016.03,514.11L1014.75,514.07L1013.77,512.13L1012.95,513.95L1010.5,514.56L1011.99,515.96L1009.55,517.19L1006.38,525.38L1007.3,528.85L1009.37,529.51L1006.02,539.64L995.55,541.33L994.6,542.56L991.27,540.36L989.67,542.9L977.39,542.9L973.19,544.13L971.42,546.38L967.55,546.34L966.45,548.49L961.45,548.35L958.63,551.25L957.34,549.79L953.51,551.31L952.26,549.73L946.6,550.12L948.03,545.63L944.33,545.13L942.59,540.16L938.25,539.64L935.46,535.67L930.41,534.03L930.41,534.03L932.57,531.77L935.7,533.37L937.57,532.22L937.55,530.87L935.72,530.65L935.3,529.25L936.5,528.18L935.55,527.31L936.62,525.39L938.95,526.81L938.87,524.24L942,518.25L943.3,519.42L949.98,519.62L955.1,516.18L957.53,517.4L958.21,515.16L960.88,514.16L962.66,511.61L965.73,513.06L965.76,507.42L967.66,508.2L967.48,506.57L969.64,505.65L969.01,503.48L971.99,504.35L975.01,502.58L973.64,500.18L978.39,497.46L979.51,493.65L981.69,492.2L979.01,491.37L981.47,489.65L979.81,487.65L981.14,485.48L980.24,482.81L981.94,476.62L980.44,474.65L985.72,472.97L987.97,470.38L990.42,473.75L991.84,464.73L994.47,460.56L991.29,456.04L986.19,456.81L984.87,453.24L981.77,450.69L981.54,447.67L977.89,447.67L975.81,444.07L963.41,433.5L964.31,432.5L970.84,434.63L976.79,431.85L978.49,427.03L984.02,426.15L983.09,420.06L966.51,408.35L957.68,409.33L950.43,417.38L944.45,416.76L941.1,418.56L910.83,385.31L910.83,385.31L911.51,383.09L915.29,383.22L912.79,379.41L916.89,377.44L916.69,374.51L918.82,373.81L916.06,368.95L918.36,368.2L918.84,366.27L931.67,365.25L933.85,361.99L936.12,362.57L937.35,360.17L935.92,354.66L937.97,344.94L935.6,343.02L936.17,340.66L933.37,340.56L934.27,338.21L933.2,334.52L941.02,319.07L937.35,317.29L938.25,316.01L936.15,315.11L932.02,305.91L932.55,298.74L930.75,295.65L931.32,291.19L929.42,287.48L927.79,278.75L929.57,276.37L930.95,267.53L925.19,262.59L924.69,258.15L919.92,256.67L913.59,251.4L912.29,248.18L912.29,248.18L917.83,248.31L920.8,250.09L924.65,247.45z"
				},
				{
					"id":"CF-HS",
					"title":"Haute-Sangha",
					"d":"M214.26,518.28L231.09,507.82L238.07,511.76L249.82,509.62L260.33,516.9L268.1,528.05L266.65,530.35L256.55,534.77L260.52,540.83L260.52,540.83L260.93,543.47L259.58,545.86L255.1,546.81L249.42,551.47L242.16,554.06L241.69,567.38L243.32,574.04L246.67,577.43L250.72,586.65L255.52,589.56L258.85,597.19L261.1,599.8L263.53,600.2L263.73,602.35L255.95,601.55L252.22,597.89L247.15,594.92L245.39,595.12L237.17,602.47L233.46,610.7L233.46,610.7L226.89,608.83L221.08,619.81L221.11,628.9L219.88,632.49L209.86,642.7L209,646.26L207.05,648.12L201.7,642.79L194.67,642.5L187.47,637.77L177.92,635.47L174.84,633.36L160.31,634.63L144.55,639.53L135.15,644.34L131.4,647.85L127.45,655.24L122.04,655.99L120.69,652.56L117.22,652.21L102.33,661.5L102.33,661.5L90.59,644.2L85.16,632.98L82.23,632.86L83.11,631.45L93.55,627.75L92.66,626.45L90.45,626.71L86.65,620.42L87.2,617.21L84.8,605.11L81.22,599.98L80.02,600.06L78.48,595.25L67.2,590.74L52.9,577.96L51.85,566.21L50.27,564.08L51.94,561.94L50.68,555.95L51.46,555.19L48.73,549.4L49.65,546.43L48.1,544.07L48.59,541.37L48.59,541.37L65.02,543.69L71.62,541.92L79.03,548.31L84.13,543.02L105.26,542.9L107.49,541.3L110.74,543.22L113.54,542.92L121.8,537.96L127.22,540.85L139.88,541.4L138.85,531.6L137.1,529.25L140.83,523.84L140.55,522.57L143,521.64L146.88,522.12L148.88,528.63L148.35,531.97L150.96,537.51L161.74,532.82L165.09,537.33L167.91,537.63z"
				},
				{
					"id":"CF-KB",
					"title":"Gribingui",
					"d":"M443.9,221.36L445.18,222.24L446.68,230.45L448.4,231.31L451.65,237.89L457.05,241.88L459.31,245.7L458.26,247.81L459.58,248.38L459.13,249.86L467.51,257.82L470.09,263.19L468.76,267.26L471.31,269.14L468.16,271.47L469.43,275.64L467.21,278.3L468.96,280.88L466.08,284.14L468.68,287.7L465.96,289.89L466.86,292.02L470.29,295.96L471.89,293.75L475.24,297.23L476.46,294.95L479.21,297.81L482.81,296.71L487.32,300.94L489.99,300.22L487.94,303.2L490.72,304.4L489.22,308.31L489.49,311.47L496.17,312.45L497.57,314.13L500.35,312.63L501.62,314.43L503,314.28L503.07,317.11L505.77,318.26L505.75,323.53L509.13,323.7L512.7,329.99L515.68,329.61L517.68,332.52L518.05,338.63L521.58,342.56L527.66,344.34L534.06,351L536.46,352.38L538.49,352.01L538.86,354.38L541.49,354.68L541.49,354.68L540.34,357.81L540.99,362.29L536.86,373.68L531.76,377.84L530.06,382.22L521.18,389.47L515,396.95L514.4,400.25L516.38,412.33L514.73,412.78L510.68,409.88L504.07,410.2L504.07,410.2L482.89,407.53L467.41,411.63L459.16,411.93L451.85,414.06L444.78,411.25L440.67,404.45L438.5,403.28L414.89,406.73L414.89,406.73L416.86,400.23L424.72,395.75L426.02,393.02L424.79,391.15L419.79,389.5L414.29,385.32L413.66,383.12L415.31,379.74L412.61,379.51L410.89,373.06L405.73,368.43L406.16,366.05L409.86,363.75L411.44,357.64L414.26,356.04L414.34,354.23L411.11,353.56L411.04,352.01L416.24,348.7L417.04,344.02L423.34,340.39L411.79,308.79L415.51,305.58L439.12,294.48L435.37,293.22L435.07,290.56L436.5,288.21L435,286L437.82,283.27L435.95,280.78L439.8,278.4L439.47,271.3L442.45,266.96L440.82,264.9L442.6,263.07L441.45,259.96L443.25,258.15L443.07,253.78L442.4,251.45L439.22,250.17L438.62,248.33L438.97,245.67L441.02,244.64L440.65,240.73L442.55,239.75L442.07,236.51L444.1,235.45L442.4,232.16L443.92,229.27L442.45,227.64L444.05,225.58z"
				},
				{
					"id":"CF-KG",
					"title":"Kémo-Gribingui",
					"d":"M414.89,406.73L438.5,403.28L440.67,404.45L444.78,411.25L451.85,414.06L459.16,411.93L467.41,411.63L482.89,407.53L504.07,410.2L504.07,410.2L503.52,412.65L504.95,415.23L512.43,418.9L516,422.88L512.88,431.8L514.98,435.73L511.65,438.63L513.23,442.07L507.82,449.47L502,449.77L500.3,453.26L490.59,459.94L493.29,471.25L491.59,473.52L497.4,476.07L497.62,481.11L496.1,483.88L487.29,490.97L479.76,492.22L479.04,493.94L483.19,499.49L528.58,498.79L528.23,503.9L523.06,513.96L523.58,519L521.61,531.6L519.23,534.91L514.11,537.15L514.11,537.15L511.47,534.51L499.88,530.95L492.33,531.41L487.14,529.81L481.26,531.91L475.88,531.22L458.9,542.28L455.4,548.09L447.6,548.83L447.6,548.83L445.35,538.8L442.05,536.66L440.87,533.07L436.17,527.93L436.5,521.69L439.77,512.54L435.27,503.83L429.09,500.26L426.52,497.16L425.54,486.48L409.34,483.91L404.21,477.23L404.21,477.23L403.73,468.43L401.86,463.76L404.38,458.11L403.08,453.39L409.59,450.87L424.29,438.33L428.62,437L429.44,435.58L424.97,431.78L424.92,420.95L413.99,410.15z"
				},
				{
					"id":"CF-LB",
					"title":"Lobaye",
					"d":"M260.52,540.83L269.25,539.3L271.38,543.49L277.41,545.79L279.61,549.55L283.21,551L284.54,554.14L297.77,560.17L303.12,566.31L305.69,580.17L310.2,585.55L316.15,586.97L317.55,585.33L322.23,585.6L325.53,584.25L330.95,586.55L332.68,590.91L335.16,590.16L338.23,592.28L342.63,589.69L351.01,591.16L351.09,592.8L352.71,593.45L357.96,591.13L359.32,592.03L364.92,601.8L373.1,603.64L375.12,606.33L378.15,612.58L378.62,620.18L377.35,623.77L378.7,627.31L383.2,630.79L384.6,634.33L388.93,635.97L389.98,639.16L399.05,643.2L400.84,645.56L400.84,645.56L400.38,659.17L404.32,680.02L400.71,679.48L395.36,667.56L390.96,663.69L387.53,668.36L384.41,668.11L384.1,670.44L378.28,667.78L374.93,669.63L371.24,669.22L368.88,677.39L364.15,679.11L360.16,672.65L356.6,671.02L347.14,670.36L346.75,672.84L344.38,672.01L341.53,668.24L339.87,670.84L334.45,674.47L331.74,666.07L323.1,663.87L320.58,665.37L311.69,664.77L306.05,660.77L301.37,659.31L294.47,661.97L294.47,661.97L290.21,653.98L285.84,648.97L271.88,642.65L265.2,641.38L260.08,637.99L254.45,637.47L251.42,634.98L241.42,618.79L233.46,610.7L233.46,610.7L237.17,602.47L245.39,595.12L247.15,594.92L252.22,597.89L255.95,601.55L263.73,602.35L263.53,600.2L261.1,599.8L258.85,597.19L255.52,589.56L250.72,586.65L246.67,577.43L243.32,574.04L241.69,567.38L242.16,554.06L249.42,551.47L255.1,546.81L259.58,545.86L260.93,543.47z"
				},
				{
					"id":"CF-MB",
					"title":"Mbomou",
					"d":"M910.83,385.31L941.1,418.56L944.45,416.76L950.43,417.38L957.68,409.33L966.51,408.35L983.09,420.06L984.02,426.15L978.49,427.03L976.79,431.85L970.84,434.63L964.31,432.5L963.41,433.5L975.81,444.07L977.89,447.67L981.54,447.67L981.77,450.69L984.87,453.24L986.19,456.81L991.29,456.04L994.47,460.56L991.84,464.73L990.42,473.75L987.97,470.38L985.72,472.97L980.44,474.65L981.94,476.62L980.24,482.81L981.14,485.48L979.81,487.65L981.47,489.65L979.01,491.37L981.69,492.2L979.51,493.65L978.39,497.46L973.64,500.18L975.01,502.58L971.99,504.35L969.01,503.48L969.64,505.65L967.48,506.57L967.66,508.2L965.76,507.42L965.73,513.06L962.66,511.61L960.88,514.16L958.21,515.16L957.53,517.4L955.1,516.18L949.98,519.62L943.3,519.42L942,518.25L938.87,524.24L938.95,526.81L936.62,525.39L935.55,527.31L936.5,528.18L935.3,529.25L935.72,530.65L937.55,530.87L937.57,532.22L935.7,533.37L932.57,531.77L930.41,534.03L930.41,534.03L926.89,534.17L927.64,537.12L926.44,537.58L924,532.91L922.41,533.1L919.58,537.51L920.99,538.84L923.21,538.09L924.34,540.09L921.15,542.15L914.21,542.63L912.11,544.58L912.19,548.55L910.08,548.74L910.18,547.23L908.63,546.53L901.8,552.33L895.48,550.95L885.21,555.81L883.74,553.93L882.84,560L877.65,557.92L873.95,559.88L872.36,558.21L866.7,562.68L861.17,562.43L849.72,566.86L842.4,572.22L839.17,572.21L836.12,574.29L835.22,579.79L831.77,579.79L829.76,578.09L827.14,578.6L822.57,576.5L821,573.08L816.08,570.52L812.77,566.4L807.52,569.11L804.53,568.43L798.47,565.03L794.36,557.46L792.03,559.47L788.91,559.25L787.2,562.24L788.55,564.7L786.05,566.4L785.23,569.13L783.42,569.67L780.13,567.57L777.82,569.43L773.86,576.56L773.34,582.74L770.89,586.36L770.21,590.3L768.52,591.2L766.95,589.51L763.75,589.14L761.23,590.3L760,596.75L763.11,598.75L763.05,601.18L759.05,603.13L756.44,607.64L756.84,613.29L748.17,621.14L731.26,622.36L722.02,618.79L715.86,613.63L710.48,612.74L710.48,612.74L710.73,609.32L713.98,606.48L713.03,600.48L719.28,590.88L720.39,585.77L718.23,584.25L714.08,583.91L707.41,586.27L702.93,585.33L701.88,584.53L703.25,581.91L699.43,578.47L699.55,575.18L697.18,575.71L696.2,573.66L692.9,573.79L691,571.17L683.8,570.1L684.47,563.84L686.62,559.9L687.1,550.33L692.1,543.17L688.65,534.74L694.55,530.32L697.13,525.61L697.48,514.46L698.9,510.04L697.6,505.13L698.3,500.01L698.3,500.01L704.2,493.74L710.43,489.65L711.38,488.18L709.26,487.28L710.11,485.71L714.68,485.63L711.56,477.47L713.76,474.82L713.96,463.43L718.33,458.09L716.86,455.39L721.84,451.07L727.94,449.1L728.94,447.32L731.49,447.22L733.29,449.77L738.47,448.9L741.49,449.82L749.35,445.67L756.32,430.9L768.58,428.35L774.78,429.65L780.44,428.4L782.79,429.65L785.96,436.2L821.8,445.65L823.93,443.52L823.53,437.78L825.35,436.55L825.78,434.2L832.71,434.2L837.23,426.2z"
				},
				{
					"id":"CF-MP",
					"title":"Ombella-Mpoko",
					"d":"M255.15,465.75L254.67,470.45L259.73,479.24L311.02,478.54L329.53,467.98L333.96,462.93L338.73,461.58L346.01,466.4L347.46,466.21L347.76,469.88L349.64,471.27L354.91,469.68L358.29,472.12L368.67,470.6L370.84,471.8L371.95,475.89L378.25,474.7L383.05,476.57L383.38,478.49L380.47,481.21L382.92,485.91L383.77,492.6L400.83,484.96L402.58,481.16L402.28,476.94L404.21,477.23L404.21,477.23L409.34,483.91L425.54,486.48L426.52,497.16L429.09,500.26L435.27,503.83L439.77,512.54L436.5,521.69L436.17,527.93L440.87,533.07L442.05,536.66L445.35,538.8L447.6,548.83L447.6,548.83L444.06,552.33L438.05,565.04L431.05,572.87L428.7,573.77L422.03,582.54L418.33,595.2L413.16,600.01L407.24,601.04L407.24,601.04L404.39,594.31L398.53,594.92L396.3,598.95L398.32,602.53L398.32,602.53L396.31,605.57L402.82,617.67L405.56,625.76L405.86,634.59L401.86,640.75L400.84,645.56L400.84,645.56L399.05,643.2L389.98,639.16L388.93,635.97L384.6,634.33L383.2,630.79L378.7,627.31L377.35,623.77L378.62,620.18L378.15,612.58L375.12,606.33L373.1,603.64L364.92,601.8L359.32,592.03L357.96,591.13L352.71,593.45L351.09,592.8L351.01,591.16L342.63,589.69L338.23,592.28L335.16,590.16L332.68,590.91L330.95,586.55L325.53,584.25L322.23,585.6L317.55,585.33L316.15,586.97L310.2,585.55L305.69,580.17L303.12,566.31L297.77,560.17L284.54,554.14L283.21,551L279.61,549.55L277.41,545.79L271.38,543.49L269.25,539.3L260.52,540.83L260.52,540.83L256.55,534.77L266.65,530.35L268.1,528.05L260.33,516.9L249.82,509.62L238.07,511.76L231.09,507.82L214.26,518.28L214.26,518.28L213.78,513.61L211.13,507.75L213.76,496.77L213.41,491.85L213.41,491.85L221.83,486.88L224.16,483.19L228.29,480.24L229.01,476.24L235.79,471.25L239.14,471.48L245.67,468.85L251.12,468.43z"
				},
				{
					"id":"CF-NM",
					"title":"Nana-Mambéré",
					"d":"M71.83,391.04L76.25,391.47L84.26,387.57L93.93,385.09L94.28,391.2L102.49,397.13L104.44,401.33L106.51,415.03L108.51,417.33L108.84,419.98L115.37,426.43L119.74,424.08L125.7,425.6L127.6,422.78L140.75,418.31L144.85,414.71L147.08,416.28L148.1,419.96L141.28,426.3L140.2,428.73L146.28,435.28L148.38,439.48L148.6,450.92L150.68,453.49L150.66,459.46L155.56,463.73L161.94,465.88L165.61,470.55L173.07,472.22L181.37,468.23L184.4,461.21L189.92,461.64L191.42,468.2L195.62,473.52L201.05,475.92L207.88,481.91L208.83,485.86L213.41,491.85L213.41,491.85L213.76,496.77L211.13,507.75L213.78,513.61L214.26,518.28L214.26,518.28L167.91,537.63L165.09,537.33L161.74,532.82L150.96,537.51L148.35,531.97L148.88,528.63L146.88,522.12L143,521.64L140.55,522.57L140.83,523.84L137.1,529.25L138.85,531.6L139.88,541.4L127.22,540.85L121.8,537.96L113.54,542.92L110.74,543.22L107.49,541.3L105.26,542.9L84.13,543.02L79.03,548.31L71.62,541.92L65.02,543.69L48.59,541.37L48.59,541.37L47.99,536.51L49.61,534.28L47.37,525.56L45.75,523.95L39.12,522.63L34.52,517.93L36.84,515.79L39.03,508.15L41.18,506.98L41.4,501.09L43.8,497.4L40.57,490.13L43.53,480.16L42.93,462.38L41.01,460.18L37.82,462.15L33.35,462.2L31.43,460.74L29.42,455.86L24.98,450.18L25.32,445.4L29.52,444.24L37.59,435.94L54.58,429.56L60.45,420.62L60.22,416.24z"
				},
				{
					"id":"CF-OP",
					"title":"Ouham-Pendé",
					"d":"M220.58,285.26L219.62,287.81L220.89,290.42L220.59,293.67L227.21,296.44L227.14,302.72L229.2,304.33L232.5,304.38L238.55,310.24L238.76,312.37L241.1,314.99L241.1,314.99L240.12,320.02L242.04,324.05L238.37,327.79L237.17,339.31L234.84,345.19L236.37,351.88L232.62,358.84L229.84,359.47L230.29,362.5L227.96,363.87L228.84,367.85L231.06,369.33L232.31,373.68L232.39,383.67L235.04,389.52L235.64,397.15L237.94,398.75L240.11,396.95L238.12,399.02L238.44,402.88L241.69,404.08L243.69,408.7L249.32,412.25L252.45,411.9L253.67,409.28L258.8,410.2L260.7,409.05L266.2,412.43L265.35,417.4L263,417.18L260.83,419.98L258.9,420.21L259.68,423.03L258.27,424.06L258.52,425.48L253.02,426.33L251.47,433.3L252.97,441L248.5,443.2L250.62,449.52L251.05,457.74L253.97,461.53L255.15,465.75L255.15,465.75L251.12,468.43L245.67,468.85L239.14,471.48L235.79,471.25L229.01,476.24L228.29,480.24L224.16,483.19L221.83,486.88L213.41,491.85L213.41,491.85L208.83,485.86L207.88,481.91L201.05,475.92L195.62,473.52L191.42,468.2L189.92,461.64L184.4,461.21L181.37,468.23L173.07,472.22L165.61,470.55L161.94,465.88L155.56,463.73L150.66,459.46L150.68,453.49L148.6,450.92L148.38,439.48L146.28,435.28L140.2,428.73L141.28,426.3L148.1,419.96L147.08,416.28L144.85,414.71L140.75,418.31L127.6,422.78L125.7,425.6L119.74,424.08L115.37,426.43L108.84,419.98L108.51,417.33L106.51,415.03L104.44,401.33L102.49,397.13L94.28,391.2L93.93,385.09L84.26,387.57L76.25,391.47L71.83,391.04L71.83,391.04L74.4,385.64L78.95,384.11L81.67,384.55L83.02,383.19L90.02,367.83L90.41,360.5L92.31,357.01L94.73,356.67L97.31,350.63L96.23,347.19L98.5,343.74L96.49,342.76L97.26,341.41L115.55,325.61L122.3,315.67L127.48,316.99L142.57,316.21L143.92,319.88L149.92,323.25L164.79,319.44L170.58,314.89L171.5,311.56L173.02,310.55L181.79,309.4L183.77,307.61L188.26,308.32L194.21,304.24L202.43,302.5L205.83,298.2L204.65,297.39L205.44,295.67L204.21,293.76L206.59,290.4L208.06,290.65L208.46,292.23L211.1,291.74L213.78,286.74L220.72,283.62z"
				},
				{
					"id":"CF-SE",
					"title":"Sangha",
					"d":"M233.46,610.7L241.42,618.79L251.42,634.98L254.45,637.47L260.08,637.99L265.2,641.38L271.88,642.65L285.84,648.97L290.21,653.98L294.47,661.97L294.47,661.97L292.59,662.94L289.75,667.84L284,665.76L279.83,667.5L278.65,670.33L272.6,671.57L271.24,670.69L262.33,673.11L260.28,676.22L257.5,673.25L254.94,673.8L253.25,672.06L245.72,672.27L245.7,674.99L243.76,676.47L235,672.31L227.57,673.68L222.04,677.67L220.48,680.41L219.02,691.52L216.99,694.83L217.34,699.51L212.6,707.9L216.09,716.33L211.49,721.83L211.2,730.34L214.31,732.92L213.89,736.34L184.35,792L181.9,789.77L182.47,787.25L180.45,780.45L173.87,770.1L174.72,767.76L173.12,764.58L174.7,758.28L173.13,754.47L175.14,749.05L172.66,748.08L171.66,740.93L173.66,739.93L175.2,737.03L170.3,724.51L167.52,722.15L164.28,723.33L157,713.59L154.57,712.47L148.89,713.26L122.7,682.76L102.33,661.5L102.33,661.5L117.22,652.21L120.69,652.56L122.04,655.99L127.45,655.24L131.4,647.85L135.15,644.34L144.55,639.53L160.31,634.63L174.84,633.36L177.92,635.47L187.47,637.77L194.67,642.5L201.7,642.79L207.05,648.12L209,646.26L209.86,642.7L219.88,632.49L221.11,628.9L221.08,619.81L226.89,608.83z"
				},
				{
					"id":"CF-UK",
					"title":"Ouaka",
					"d":"M629.02,299.59L636.5,307.14L646.21,309.32L652.58,314.25L655.41,319.97L654.08,332.17L655.11,334.8L662.04,335.78L667.09,334.93L669.06,336.25L669.09,347.15L671.67,363.77L674.44,364.77L674.22,369.78L676.12,373.83L674.67,376.41L675.19,380.01L671.97,382.27L671.92,383.84L674.29,385.89L674.82,391.22L680.37,399.68L686.77,400.43L688.77,402.55L686.92,413.33L690.32,422.23L683.6,433.23L688.35,436.85L691.17,444.9L690.95,448.55L697.18,449.69L699.13,457.44L702.35,461.16L701.9,469.15L698.38,482.56L694.52,487.58L685.92,482.11L676.84,489.25L676.92,493.57L676.92,493.57L674.54,499.59L667.84,500.91L666.29,497.99L663.41,497.51L660.61,490.57L660.66,486.11L657.84,481.16L654.86,480.34L653.08,477.24L650.51,480.79L647.66,478.57L643.85,482.41L638.43,484.91L633.42,482.54L632,483.93L628.35,484.36L624.55,479.22L620.37,478.57L619.94,480.51L622.47,484.46L619.12,489L619.62,493.32L612.64,495.12L611.69,496.37L615.37,499.11L616.27,504.8L613.04,508.69L613.99,514.63L613.12,523.69L608.29,532L611.72,540.08L607.67,548.33L608.77,559.08L605.26,561.65L600.06,560.75L591.23,565.21L578.93,579.67L567.95,585.02L567.95,585.02L568.03,576.34L558.1,565.23L544.88,558.4L541.33,554.04L535.51,551.3L529.37,545.96L519.56,544.73L515.85,541.36L514.11,537.15L514.11,537.15L519.23,534.91L521.61,531.6L523.58,519L523.06,513.96L528.23,503.9L528.58,498.79L483.19,499.49L479.04,493.94L479.76,492.22L487.29,490.97L496.1,483.88L497.62,481.11L497.4,476.07L491.59,473.52L493.29,471.25L490.59,459.94L500.3,453.26L502,449.77L507.82,449.47L513.23,442.07L511.65,438.63L514.98,435.73L512.88,431.8L516,422.88L512.43,418.9L504.95,415.23L503.52,412.65L504.07,410.2L504.07,410.2L510.68,409.88L514.73,412.78L516.38,412.33L514.4,400.25L515,396.95L521.18,389.47L530.06,382.22L531.76,377.84L536.86,373.68L540.99,362.29L540.34,357.81L541.49,354.68L541.49,354.68L542.16,356.49L546.22,357.59L548.04,360.04L555.34,359.89L558.32,361.39L560.22,360.24L562.72,360.67L563.92,359.34L565.72,361.27L567.77,361.32L573.38,357.06L578.33,356.91L584.96,351.18L588.71,341.19L592.31,340.61L598.86,342.69L609.19,336.3L618.99,321.47L624.47,316.74L622.2,312.25L622.22,309.37L625.72,306.76L627.07,301.04z"
				},
				{
					"id":"CF-VK",
					"title":"Vakaga",
					"d":"M756.13,0.86L758.48,2.13L762.41,0.96L766.32,2.56L773.4,3.02L776.49,5.78L786.63,6.99L786.99,10.28L790.18,13.21L797.18,25.76L809.02,33.48L816.17,42.07L824.5,48.52L857.48,101.52L860.15,121.83L853.91,133.23L856.35,133.74L854.36,139.42L855.29,141.97L857.45,140.96L858.31,142.6L854.86,151.26L856.32,156.48L846.46,166.27L841.61,166.72L839.98,170.7L839.98,170.7L837.73,166.06L839.61,161.07L834.76,160.67L830.85,162.91L828.58,166.66L826.15,179.87L821.58,183.12L815.4,183.97L805.65,191.09L804.54,193.15L804.54,201.58L802.44,204.64L798.09,203.86L791.76,204.87L780.66,209.42L767.73,209.52L759.6,214.45L754.27,219.82L750.75,220.15L746.42,218.57L742.49,219.32L742.49,219.32L742.69,213.97L741.47,212.51L726.26,209.34L718.31,203.76L714.66,188.15L715.33,185.08L709.03,181.73L707.18,175.97L701.13,172.35L698.38,168.12L693.77,165.88L691.57,158.61L688.6,155.06L687.22,145.66L682.12,141.58L680.85,137.4L674.99,132.34L673.04,128.66L666.04,129.06L664.24,127.85L662.01,112.65L657.89,112.27L655.81,115.98L649.23,119.26L645.33,122.81L643.83,126.49L640.55,129.49L636.1,131.15L626.67,131.98L621.32,134.66L617.82,140.73L611.47,142.99L607.24,148.26L603.36,147.75L599.64,142.26L599.64,142.26L601.7,143.36L601.66,140.42L605.22,138.19L605.95,134.93L609.62,134.74L610.71,130.6L612.89,130.89L612.88,126.49L616.17,126.1L614.29,124.12L616.68,123.84L615.57,122.05L617.12,120.27L614.35,118.7L617.64,118.39L616.79,114.64L619.99,116.32L619.99,112.19L622.94,112.97L627.63,110.56L629.23,105.48L635.16,101.17L635.5,97.96L640.12,92.54L644.06,94.57L645.11,92.57L647.53,94.82L649.18,94.37L649.87,92.67L652.7,91.56L653.96,87.93L658.21,83.77L657.77,80.43L664.33,72.08L666.22,70.96L667.78,72.55L670.25,72.47L673.28,70.64L677.42,70.6L676.73,68.67L678.71,67.65L678.15,66.4L680.77,66.56L682.81,64.25L683.64,62.57L682.35,60.13L683.94,59.47L684.14,56.98L686.66,54.25L681.85,45.5L683.23,41.28L683.3,32.2L685.55,33.27L688.25,30.8L688.24,19.4L692.21,15.31L695.14,14.67L696.55,12.54L703.7,13.61L703.88,12.42L705.71,13.11L708.77,11.16L713.96,10.18L720.95,11.99L724.89,9.02L733.38,6.94L736.71,4.72L745.48,3.36L747.15,1.74L753.11,0.03z"
				}
			]
		}
	}
};